/********************************************************************
 FileName:		user.c
********************************************************************/

/** INCLUDES *******************************************************/
#include "delays.h"
#include "math.h"

#include "include/Compiler.h"
#include "include/GenericTypeDefs.h"
#include "HardwareProfile.h"
#include "usb_config.h"
#include "include_usb/usb_device.h"
#include "include_usb/usb.h"
#include "include_usb/usb_function_generic.h"

#include "ax12.h"			//Functions for AX12 servos
#include "init.h"
#include "user.h"

/** V A R I A B L E S ********************************************************/
#pragma udata
BYTE 	old_sw2;
BYTE 	counter;
WORD_VAL consigne_AUTO;
WORD_VAL RPM_renv;
WORD_VAL commande_renv;
DWORD_VAL commande_renv2;
BYTE 	ETAT;
char 	mode;
BOOL 	flag_chg_mode=0;
char 	movingSpeedlow[3] = { 0x20, 0xF0, 0x00 };
// variables du fichier interuption.c
extern WORD consigne;
extern WORD commande_AX12;
extern WORD RPM;
extern BOOL etat_moteur;
extern float som_erreur, diff_erreur;
extern float P,I,D;
extern int tab_erreur[5];
extern float temporaire2;
extern float temporaire;

#pragma udata USB_VARS
DATA_PACKET INPacket;
DATA_PACKET OUTPacket;
#pragma udata

USB_HANDLE USBGenericOutHandle = 0;
USB_HANDLE USBGenericInHandle = 0;

/** P R I V A T E  P R O T O T Y P E S ***************************************/
void UserInit(void);
void BlinkUSBStatus(void);
BOOL Switch2IsPressed(void);
WORD ReadPOT(void);
void ServiceRequests(void);
void renvoi_etat(void);

/** D E C L A R A T I O N S **************************************************/
#pragma code

// ***********************************
// procedure d'initialisation
// ***********************************
void UserInit(void)
{
    mInitAllLEDs();
    mInitAllSwitches();
    old_sw2 = sw2;
	mInitCAPT();
	mInitPOT();	
// init du servomoteur
	init_AX12();
// interuption
	init_interupt();
}//end UserInit

/******************************************************************************
 * Function:        void ProcessIO(void)
 *
 * Overview:        This function is a place holder for other user routines.
 *                  It is a mixture of both USB and non-USB tasks.
 *****************************************************************************/
void ProcessIO(void)
{   
	mLED_3=1;	
	BlinkUSBStatus();
    // User Application USB tasks
    if((USBDeviceState < CONFIGURED_STATE)||(USBSuspendControl==1)) return;

    //respond to any USB commands that might have come over the bus
	//PollTempOnHPCExplorer();			
    ServiceRequests();

if((mode2==1)&&(mode1==0)) 
{	
	if((mode==AUTO)||(mode==MANU)) flag_chg_mode=1;
	mode=MANU_AUTO;
	consigne = ReadPOT()*8000/255;
}

if((mode1==1)&&(mode2==0))
{
	if((mode==MANU_AUTO)||(mode==MANU)) flag_chg_mode=1;
	mode=AUTO;
	consigne = consigne_AUTO.Val;
}

if((mode1==0)&&(mode2==0))
{
	if((mode==AUTO)||(mode==MANU_AUTO)) flag_chg_mode=1;
	mode=MANU;
	commande_AX12 = ReadPOT();
}

if(flag_chg_mode==1)
{
flag_chg_mode=0;
AX_TxPacket(0x01, I_WRITE_DATA, movingSpeedlow, 3);
T3CONbits.TMR3ON = 1;	// timer3 ON
PIE2bits.TMR3IE = 1;	// valide interuption Timer3		
}
	mLED_3=0;	

}//end ProcessIO

/******************************************************************************
 * Function:        WORD ReadPOT(void)
 *
 * Output:          WORD - the 10-bit right justified POT value
 *
 * Side Effects:    ADC buffer value updated
 *
 * Overview:        This function reads the POT and leaves the value in the 
 *                  ADC buffer register
 *****************************************************************************/
WORD ReadPOT(void)
{
	WORD_VAL w;

    ADCON0bits.GO = 1;              // Start AD conversion
    while(ADCON0bits.NOT_DONE);     // Wait for conversion
	w.LB = ADRESL;
	w.HB = ADRESH;

return w.Val;
}//end ReadPOT

/******************************************************************************
 * Function:        void ServiceRequests(void)
 *
 * Side Effects:    USB traffic can be generated
 *
 * Overview:        This function takes in the commands from the PC from the
 *                  application and executes the commands requested
 *****************************************************************************/
void ServiceRequests(void)
{
    BYTE index;
    mLED_4=1;
    //Check to see if data has arrived
    if(!USBHandleBusy(USBGenericOutHandle))
    {        
        //if the handle is no longer busy then the last
        //transmission is complete
       
        counter = 0;

        INPacket.CMD=OUTPacket.CMD;
        INPacket.len=OUTPacket.len;

        //process the command
        switch(OUTPacket.CMD)
        {
            case READ_VERSION:
                //dataPacket._byte[1] is len
                INPacket._byte[2] = MINOR_VERSION;
                INPacket._byte[3] = MAJOR_VERSION;
                counter=0x04;
                break;

			case CONSIGNE:
                {
				WORD_VAL w;
				//dataPacket._byte[1] is len
				consigne_AUTO.HB = OUTPacket._byte[2];
				consigne_AUTO.LB = OUTPacket._byte[3];
				renvoi_etat();
				INPacket._byte[2] = ETAT;
				w.Val=ReadPOT();
				INPacket._byte[3] = w.HB;
				INPacket._byte[4] = w.LB;
				RPM_renv.Val=RPM;
                INPacket._byte[5] = RPM_renv.HB;
				INPacket._byte[6] = RPM_renv.LB;
				commande_renv.Val=(int)temporaire;
				INPacket._byte[7] = commande_renv.HB;
				INPacket._byte[8] = commande_renv.LB;
				commande_renv.Val=(int)(temporaire2*100);
				INPacket._byte[9] = commande_renv.HB;
				INPacket._byte[10] = commande_renv.LB;
/*				commande_renv.Val=(int)commande_AX12;
				INPacket._byte[11] = commande_renv.HB;
				INPacket._byte[12] = commande_renv.LB;
*/				counter=13;
				}
                break;
           
            case RESET:
                Reset();
                break;
                
            default:
                Nop();
                break;
        }//end switch()
        if(counter != 0)
        {
            if(!USBHandleBusy(USBGenericInHandle))
            {
                USBGenericInHandle = USBGenWrite(USBGEN_EP_NUM,(BYTE*)&INPacket,counter);
            }
        }//end if
        
        //Re-arm the OUT endpoint for the next packet
        USBGenericOutHandle = USBGenRead(USBGEN_EP_NUM,(BYTE*)&OUTPacket,USBGEN_EP_SIZE);
    }//end if
mLED_4=0;
    
}//end ServiceRequests

/********************************************************************
 * Function:        void BlinkUSBStatus(void)
 *
 * Overview:        BlinkUSBStatus turns on and off LEDs 
 *                  corresponding to the USB device state.
 *
 * Note:            mLED macros can be found in HardwareProfile.h
 *                  USBDeviceState is declared and updated in
 *                  usb_device.c.
 *******************************************************************/
void BlinkUSBStatus(void)
{
    static WORD led_count=0;
    
    if(led_count == 0)led_count = 10000U;
    led_count--;

    #define mLED_Both_Off()         {mLED_1_Off();mLED_2_Off();}
    #define mLED_Both_On()          {mLED_1_On();mLED_2_On();}
    #define mLED_Only_1_On()        {mLED_1_On();mLED_2_Off();}
    #define mLED_Only_2_On()        {mLED_1_Off();mLED_2_On();}

    if(USBSuspendControl == 1)
    {
        if(led_count==0)
        {
            mLED_1_Toggle();
            mLED_2 = mLED_1;        // Both blink at the same time
        }//end if
    }
    else
    {
        if(USBDeviceState == DETACHED_STATE)
        {
            mLED_Both_Off();
        }
        else if(USBDeviceState == ATTACHED_STATE)
        {
            mLED_Both_On();
        }
        else if(USBDeviceState == POWERED_STATE)
        {
            mLED_Only_1_On();
        }
        else if(USBDeviceState == DEFAULT_STATE)
        {
            mLED_Only_2_On();
        }
        else if(USBDeviceState == ADDRESS_STATE)
        {
            if(led_count == 0)
            {
                mLED_1_Toggle();
                mLED_2_Off();
            }//end if
        }
        else if(USBDeviceState == CONFIGURED_STATE)
        {
            if(led_count==0)
            {
                mLED_1_Toggle();
                mLED_2 = !mLED_1;       // Alternate blink                
            }//end if
        }//end if(...)
    }//end if(UCONbits.SUSPND...)

}//end BlinkUSBStatus


/******************************************************************************
 * Function:        BOOL Switch2IsPressed(void)
 *
 * Overview:        returns TRUE if the SW2 was pressed and FALSE otherwise
 *****************************************************************************/
BOOL Switch2IsPressed(void)
{
    if(sw2 != old_sw2)
    {
        old_sw2 = sw2;                  // Save new value
        if(sw2 == 0)                    // If pressed
            return TRUE;                // Was pressed
    }//end if
    return FALSE;                       // Was not pressed
}//end Switch2IsPressed

// ***********************************
// Calcul du mot a renvoyer
// ***********************************
void renvoi_etat(void)
{
ETAT = 0;
if(etat_moteur==TRUE) ETAT += 1;
if(mode==AUTO) ETAT += 2;
if(mode==MANU) ETAT += 4;
if(mode==MANU_AUTO) ETAT += 8;
if(flag_chg_mode==1) ETAT += 16;
}

/** EOF user.c ***************************************************************/
